!function($) {
    "use strict";

    var CalendarApp = function() {
        this.$body = $("body")
        this.$calendar = $('#calendar'),
        this.$event = ('#calendar-events div.calendar-events'),
        this.$categoryForm = $('#add-new-event form'),
        this.$extEvents = $('#calendar-events'),
        this.$modal = $('#my-event'),
        this.$saveCategoryBtn = $('.save-category'),
        this.$calendarObj = null
    };

    /* on drop */
    CalendarApp.prototype.onDrop = function(eventObj, date, dateStr) {
        var $this = this;
        // retrieve the dropped element's stored Event Object
        var originalEventObject = eventObj.data('eventObject');
        var $categoryClass = eventObj.attr('data-class');
        // we need to copy it, so that multiple events don't have a reference to the same object
        var copiedEventObject = $.extend({}, originalEventObject);
        // assign it the date that was reported
        copiedEventObject.start = date;
        if ($categoryClass)
            copiedEventObject['className'] = [$categoryClass];
        // render the event on the calendar
        $this.$calendar.fullCalendar('renderEvent', copiedEventObject, true);
        // is the "remove after drop" checkbox checked?
        if ($('#drop-remove').is(':checked')) {
            // if so, remove the element from the "Draggable Events" list
            eventObj.remove();
        }
    }
    ,
    /* on click on event */
    CalendarApp.prototype.onEventClick = function(calEvent, jsEvent, view) {
        var timezoneOffset = new Date().getTimezoneOffset() * -1;
        var $this = this;
        var modalDiv = $("<div></div>")
        var subDiv = $("<div class='modal-header'></div>");
        var form = $("<form></form>");
        subDiv.append("<label class='control-label' style='font-size: 25px'><strong><i class='icon-calender'></i>" + "  " + calEvent.title + "</strong></label><br>");
        subDiv.append("<label class='control-label'>" + (calEvent.description != null ? calEvent.description : " ") + "</label><br><br>");
        console.log(calEvent.start._d.toDateString() + " to " + calEvent.end._d.toDateString());
        subDiv.append("<label class='control-label'><span class='glyphicon glyphicon-time'></span> " + calEvent.start._d.toDateString() + " at " + calEvent.start._d.getHours() + ":" + ((calEvent.start._d.getMinutes() > 9) ? calEvent.start._d.getMinutes() : calEvent.start._d.getMinutes() + "0") + " to " + calEvent.end._d.toDateString() + " at " + calEvent.end._d.getHours() + ":" + ((calEvent.end._d.getMinutes() > 9) ? calEvent.end._d.getMinutes() : calEvent.end._d.getMinutes() + "0") + "</label");

        form.append(document.getElementById('form-data'));
        modalDiv.append(subDiv);
        modalDiv.append(form);
        //form.append("<div class='row'><div class='col-md-6'><label class='control-label' style='padding-top: 8px'> Event Name</label><input class='form-control form-white' type=text value='" + calEvent.title + "' type='text' name='event-title' id='event-name'/></div><div class='col-md-6'><label class='control-label' style='padding-top: 8px'> Event Description</label><input class='form-control form-white' placeholder='Enter Summary' type='text' name='event-summary' id='event-summary'/></div><br><div class='col-md-6'><label class='control-label' style='padding-top: 8px;'> Choose Start Date</label><div class='input-group'><input class='form-control form-white datepicker' placeholder='Enter Start Date' type='text' id='start-date' name='startDate-selection'><span class='input-group-addon'><i class='icon-calender'></i></span></div></div><div class='col-md-6'><label class='control-label' style='padding-top: 8px;'> Choose Start Time</label><div class='input-group clockpicker' id='end-clockpicker' data-placement='bottom' data-align='top' data-autoclose='true'><input class='form-control form-white timepicker' placeholder='Enter Start Time' type='text' id='start-time' name='startTime-selection'> <span class='input-group-addon'> <span class='glyphicon glyphicon-time'></span> </span></div></div><div class='col-md-6'><label class='control-label' style='padding-top: 8px;'> Choose End Date</label><div class='input-group'><input class='form-control form-white datepicker' placeholder='Enter End Date' type='text' id='end-date' name='endDate-selection'><span class='input-group-addon'><i class='icon-calender'></i></span> </div></div><div class='col-md-6'><label class='control-label' style='padding-top: 8px;'> Choose End Time</label><div class='input-group clockpicker' id='end-clockpicker' data-placement='bottom' data-align='top' data-autoclose='true'><input class='form-control form-white timepicker' placeholder='Enter End Time' type='text' id='end-time' name='endTime-selection'> <span class='input-group-addon'> <span class='glyphicon glyphicon-time'></span> </span></div></div>");
        //form.append("<div class='input-group'><input class='form-control' type=text value='" + calEvent.title + "' /> <span class='input-group-btn'><button type='submit' class='btn btn-success waves-effect waves-light'><i class='fa fa-check'></i> Save</button></span></div>");
        $this.$modal.modal({
            backdrop: 'static'
        });
        $this.$modal.find('.delete-event').show().end().find('.save-event').show().click(function() {
            $('form').submit()
        }).end().find('.modal-body').empty().prepend(modalDiv).end().find('.delete-event').unbind('click').click(function() {
            $this.$calendarObj.fullCalendar('removeEvents', function(ev) {
                return (ev._id == calEvent._id);
            });
            deleteEvent(jsEvent.currentTarget.id);
            $this.$modal.modal('hide');
            location.reload();
        });
        $this.$modal.find('form').on('submit', function() {
            updateEvent(form, jsEvent.currentTarget.id);
            calEvent.title = form.find("input[type=text]").val();
            $this.$calendarObj.fullCalendar('updateEvent', calEvent);
            $this.$modal.modal('hide');
            return false;
            l
        });
    }
    ,
    /* on select */
    CalendarApp.prototype.onSelect = function(start, end, allDay) {
        var $this = this;
        $this.$modal.modal({
            backdrop: 'static'
        });

        var eventDisplayForm = $("<form></form>");
        form.append("<div class='row'></div>");

        $this.$modal.find('form').on('submit', function() {
            var form = $("<form></form>");
            form.append("<div class='row'></div>");
            form.find(".row").append("<div class='col-md-6'><div class='form-group'><label class='control-label'>Event Name</label><input class='form-control' placeholder='Insert Event Name' type='text' name='title'/></div></div>").append("<div class='col-md-6'><div class='form-group'><label class='control-label'>Category</label><select class='form-control' name='category'></select></div></div>").find("select[name='category']").append("<option value='bg-danger'>Danger</option>").append("<option value='bg-success'>Success</option> ").append("<option value='bg-purple'>Purple</option>").append("<option value='bg-primary'>Primary</option>").append("<option value='bg-pink'>Pink</option>").append("<option value='bg-info'>Info</option>").append("<option value='bg-warning'>Warning</option></div></div>");
            $this.$modal.find('.delete-event').hide().end().find('.save-event').show().end().find('.modal-body').empty().prepend(form).end().find('.save-event').unbind('click').click(function() {
                form.submit();
            });
            $this.$modal.find('form').on('submit', function() {
                var title = form.find("input[name='title']").val();
                var beginning = form.find("input[name='beginning']").val();
                var ending = form.find("input[name='ending']").val();
                var categoryClass = form.find("select[name='category'] option:checked").val();
                if (title !== null && title.length != 0) {
                    $this.$calendarObj.fullCalendar('renderEvent', {
                        title: title,
                        start: start,
                        end: end,
                        allDay: false,
                        className: categoryClass
                    }, true);
                    $this.$modal.modal('hide');
                } else {
                    alert('You have to give a title to your event');
                }
                return false;

            });
        });
        $this.$calendarObj.fullCalendar('unselect');
    }
    ,
    CalendarApp.prototype.enableDrag = function() {
        //init events
        $(this.$event).each(function() {
            // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
            // it doesn't need to have a start or end
            var eventObject = {
                title: $.trim($(this).text())// use the element's text as the event title
            };
            // store the Event Object in the DOM element so we can get to it later
            $(this).data('eventObject', eventObject);
            // make the event draggable using jQuery UI
            $(this).draggable({
                zIndex: 999,
                revert: true,
                // will cause the event to go back to its
                revertDuration: 0 //  original position after the drag
            });
        });
    }

    /* Initializing */
    CalendarApp.prototype.init = function() {
        this.enableDrag();

        /*  Initialize the calendar  */
        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();
        var form = '';
        var today = new Date($.now());

        var defaultEvents = [/*{
            title: 'Released Ample Admin!',
            start: new Date($.now() + 506800000),
            className: 'bg-info'
        }, {
            title: 'This is today check date',
            start: today,
            end: today,
            className: 'bg-danger'
        }, {
            title: 'This is your birthday',
            start: new Date($.now() + 848000000),
            className: 'bg-info'
        },{
            title: 'your meeting with john',
            start: new Date($.now() - 1099000000),
            end:  new Date($.now() - 919000000),
            className: 'bg-warning'
        },{
            title: 'your meeting with john',
            start: new Date($.now() - 1199000000),
            end: new Date($.now() - 1199000000),
            className: 'bg-purple'
        },{
            title: 'your meeting with john',
            start: new Date($.now() - 399000000),
            end: new Date($.now() - 219000000),
            className: 'bg-info'
        },  
        {
            title: 'Hanns birthday',
            start: new Date($.now() + 868000000),
            className: 'bg-danger'
        },{
            title: 'Like it?',
            start: new Date($.now() + 348000000),
            className: 'bg-success'
        } */
        ];

        var timezoneOffset = (new Date().getTimezoneOffset() / 60);

        for (var i = 0; i < calendarEvents.length; i++) {
            console.log(calendarEvents[i]);
            defaultEvents.push({
                title: calendarEvents[i].summary,
                description: calendarEvents[i].description,
                start: (calendarEvents[i].start.dateTime != null) ? (calendarEvents[i].start.dateTime) : (calendarEvents[i].start.date),
                end: (calendarEvents[i].end.dateTime != null) ? (calendarEvents[i].end.dateTime) : (calendarEvents[i].end.date),
                allDay: (calendarEvents[i].end.dateTime != null) ? false : true,
                id: calendarEvents[i].id
            });
        }

        console.log(defaultEvents);

        var $this = this;
        $this.$calendarObj = $this.$calendar.fullCalendar({
            slotDuration: '00:01:00',
            /* If we want to split day time each 1 minute */
            minTime: '00:00:00',
            maxTime: '24:00:00',
            defaultView: 'month',
            handleWindowResize: true,

            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,agendaWeek,agendaDay'
            },
            events: defaultEvents,
            editable: false,
            droppable: false,
            // this allows things to be dropped onto the calendar !!!
            eventLimit: true,
            // allow "more" link when too many events
            selectable: false,
            drop: function(date) {
                $this.onDrop($(this), date);
            },
            select: function(start, end, allDay) {
                $this.onSelect(start, end, allDay);
            },
            eventClick: function(calEvent, jsEvent, view) {
                $this.onEventClick(calEvent, jsEvent, view);
            }

        });
        //on new event
        this.$saveCategoryBtn.on('click', function() {
            /*
            if (categoryName !== null && categoryName.length != 0) {
                $this.$extEvents.append('<div class="calendar-events bg-' + categoryColor + '" data-class="bg-' + categoryColor + '" style="position: relative;"><i class="fa fa-move"></i>' + categoryName + '</div>')
                $this.enableDrag();
            }
            */
            //location.reload();
        });
    }
    ,

    //init CalendarApp
    $.CalendarApp = new CalendarApp,
    $.CalendarApp.Constructor = CalendarApp

}(window.jQuery),

//initializing CalendarApp
function($) {
    "use strict";
    $.CalendarApp.init()
}(window.jQuery);
